#ifndef __CVst__
#define __CVst__

namespace Exponent
{
	namespace Vst
	{
		/**
		 * @class CVst CVst.hpp
		 * @brief Has statics related to VST
		 *
		 * @date 15/02/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @note Taken straight from the VST specification
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
		 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
		 *
		 * $Id: CVst.hpp,v 1.3 2007/02/08 21:08:23 paul Exp $
		 */
		class CVst
		{
		public:

//	===========================================================================

			const static long CVST_I_CAN_DO		    =  1;		/**< Vst can do requested operation */
			const static long CVST_I_CANT_DO		= -1;		/**< Vst can't do requested operation */
			const static long CVST_I_DONT_KNOW	    =  0;		/**< Vst doesnt know if it can do requested operation */
			const static long CVST_WANT_MORE_EVENTS =  1;		/**< Vst wants more midi events */
			const static long CVST_STRING_LENGTH	= 24;		/**< Vst string length for getting descriptions */

//	===========================================================================
		};
	}
}
#endif	// End of CVst.hpp